# -*- coding: utf-8 -*-
import sys
import ConfigParser
import os
import time
import math
import string
import RPi.GPIO as GPIO
import math


GPIO.setwarnings(False)
GPIO.setmode(GPIO.BCM)

HIGH = True  # HIGH-Pegel
LOW  = False # LOW-Pegel



# Funktionsdefinition
def alarm_email(SERVER,USER,PASSWORT,FROM,TO,SUBJECT,MESSAGE):
    from smtplib import SMTP as smtp
    from email.mime.text import MIMEText as text

    s = smtp(SERVER)

    s.login(USER,PASSWORT)

    m = text(MESSAGE)

    m['Subject'] = SUBJECT
    m['From'] = FROM
    m['To'] = TO


    s.sendmail(FROM,TO, m.as_string())
    s.quit()



def readAnalogData(adcChannel, SCLKPin, MOSIPin, MISOPin, CSPin):
    # Pegel vorbereiten
    GPIO.output(CSPin,   HIGH)    
    GPIO.output(CSPin,   LOW)
    GPIO.output(SCLKPin, LOW)
        
    sendcmd = adcChannel
    sendcmd |= 0b00011000 # Entspricht 0x18 (1:Startbit, 1:Single/ended)
    
    # Senden der Bitkombination (Es finden nur 5 Bits Beruecksichtigung)
    for i in range(5):
        if (sendcmd & 0x10): # (Bit an Position 4 pruefen. Zaehlung beginnt bei 0)
            GPIO.output(MOSIPin, HIGH)
        else:
            GPIO.output(MOSIPin, LOW)
        # Negative Flanke des Clocksignals generieren    
        GPIO.output(SCLKPin, HIGH)
        GPIO.output(SCLKPin, LOW)
        sendcmd <<= 1 # Bitfolge eine Position nach links schieben
            
    # Empfangen der Daten des ADC
    adcvalue = 0 # Ruecksetzen des gelesenen Wertes
    for i in range(13):
        GPIO.output(SCLKPin, HIGH)
        GPIO.output(SCLKPin, LOW)
        # print GPIO.input(MISOPin)
        adcvalue <<= 1 # 1 Postition nach links schieben
        if(GPIO.input(MISOPin)):
            adcvalue |= 0x01
    #time.sleep(0.1)
    return adcvalue

def temperatur_sensor (Rt, typ): #Ermittelt die Temperatur
    
    
    if typ=='ACURITE':
      # Kennlinienkonstanten Sensor ACURITE/Ventus
      a = 0.003344
      b = 0.000251911
      c = 0.00000351094
      Rn = 47

    if typ=='FANTAST':
      # Kennlinienkonstanten Sensor IKEA FANTAST
       a = 0.003339
       b = 0.000251911
       c = 0.00000351094
       Rn = 47
    
    if typ=='MAVERICK':
      # Kennlinienkonstanten Sensor MAVERICK UBRAUCHBAR!!
       a = 0.0034230
       b = 0.000251911
       c = 0.00000351094
       Rn = 1000 
    
    if typ=='ROSENSTEIN':
      # Kennlinienkonstanten Rosenstein und Soehne RF-T0601
       a = 0.003362
       b = 0.000251911
       c = 0.00000351094
       Rn = 100 

    
    try: 
       v = math.log(Rt/Rn)
       T = (1/(a + b*v + c*v*v)) - 273
    except: #bei unsinnigen Werten (z.B. ein- ausstecken des Sensors im Betrieb) Wert 999.9
       T = 999.9
    return T


def dateiname(): #Zeitstring fuer eindeutige Dateinamen erzeugen

    zeit = time.localtime()
    fn = string.zfill(zeit[2],2)+string.zfill(zeit[1],2)+str(zeit[0])+string.zfill(zeit[3],2)+string.zfill(zeit[4],2)+string.zfill(zeit[5],2)
    return fn

def lcd_init():  # Initialisierung Display und Definition Sonderzeichen Pfeil runter ASCII 0 und Pfeil hoch ASCII 1
  lcd_byte(0x33,LCD_CMD) # Noch im 8 Bit Modus also 30 30 
  lcd_byte(0x32,LCD_CMD) # 30 20 (30 = 8 Bit, 20 =4-Bit Modus)
  lcd_byte(0x28,LCD_CMD) # 4-Bit, 2-Zeilig, 5x8 Font
  lcd_byte(0x0C,LCD_CMD) # Display ein 
  
  lcd_byte(0x40,LCD_CMD) # Sonderzeichen 0 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x15,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x0E,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 0 definieren
  lcd_byte(0x00,LCD_CHR) # Sonderzeichen 0 definieren

  lcd_byte(0x48,LCD_CMD) # Sonderzeichen 1 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x0E,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x15,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x04,LCD_CHR) # Sonderzeichen 1 definieren
  lcd_byte(0x00,LCD_CHR) # Sonderzeichen 1 definieren


  lcd_byte(0x06,LCD_CMD) # Cursor nach rechts wandernd, kein Displayshift
  lcd_byte(0x01,LCD_CMD) # Display loeschen 
 
  

def lcd_string(message,style):
  # Sende String zum  Display
  # style=1 Linksbuendig
  # style=2 Zentriert
  # style=3 Rechtsbuendig

  if style==1:
    message = message.ljust(LCD_WIDTH," ")  
  elif style==2:
    message = message.center(LCD_WIDTH," ")
  elif style==3:
    message = message.rjust(LCD_WIDTH," ")

  for i in range(LCD_WIDTH):
    lcd_byte(ord(message[i]),LCD_CHR)

def lcd_byte(bits, mode):
  # Sende Byte an die Daten-Leitungen des Displays
  # bits = data
  # mode = True  fuer Zeichen
  #        False fuer Kommando

  GPIO.output(LCD_RS, mode) # RS

  # High Nibble uebertragen
  GPIO.output(LCD_D4, False)
  GPIO.output(LCD_D5, False)
  GPIO.output(LCD_D6, False)
  GPIO.output(LCD_D7, False)
  if bits&0x10==0x10:
    GPIO.output(LCD_D4, True)
  if bits&0x20==0x20:
    GPIO.output(LCD_D5, True)
  if bits&0x40==0x40:
    GPIO.output(LCD_D6, True)
  if bits&0x80==0x80:
    GPIO.output(LCD_D7, True)

  # Toggle 'Enable' pin
  time.sleep(E_DELAY)    
  GPIO.output(LCD_E, True)  
  time.sleep(E_PULSE)
  GPIO.output(LCD_E, False)  
  time.sleep(E_DELAY)      

  # Low Nibble uebertragen
  GPIO.output(LCD_D4, False)
  GPIO.output(LCD_D5, False)
  GPIO.output(LCD_D6, False)
  GPIO.output(LCD_D7, False)
  if bits&0x01==0x01:
    GPIO.output(LCD_D4, True)
  if bits&0x02==0x02:
    GPIO.output(LCD_D5, True)
  if bits&0x04==0x04:
    GPIO.output(LCD_D6, True)
  if bits&0x08==0x08:
    GPIO.output(LCD_D7, True)

  # Toggle 'Enable' pin
  time.sleep(E_DELAY)    
  GPIO.output(LCD_E, True)  
  time.sleep(E_PULSE)
  GPIO.output(LCD_E, False)  
  time.sleep(E_DELAY)   





# Variablendefinition und GPIO Pin-Definition
ADC_Channel = 0  # Analog/Digital-Channel
#GPIO START
SCLK        = 18 # Serial-Clock
MOSI        = 24 # Master-Out-Slave-In
MISO        = 23 # Master-In-Slave-Out
CS          = 25 # Chip-Select
LED_ROT     = 2 # Rote LED 
LED_GELB    = 3 # Gelbe LED
LED_GRUEN   = 4 # Gruene LED
BEEPER      = 17 # Piepser
LCD_RS      = 7  # RS-Leitung Display
LCD_E       = 8  # Enable-Leitung Display
LCD_D4      = 22 # Data-4 Display
LCD_D5      = 10 # Data-5 Display
LCD_D6      = 9  # Data-6 Display
LCD_D7      = 11 # Data-7 Display
#GPIO END

LCD_WIDTH = 20  # Maximum Zeichen pro Zeile
LCD_CHR = True  # Charakter/DATA an das Display
LCD_CMD = False # Kommando an das Display

LCD_LINE_1 = 0x80 # LCD RAM Adresse fuer die erste Zeile
LCD_LINE_2 = 0xC0 # LCD RAM Adresse fuer die zweite Zeile
LCD_LINE_3 = 0x94 # LCD RAM Adresse fuer die dritte Zeile
LCD_LINE_4 = 0xD4 # LCD RAM Adresse fuer die vierte Zeile 

# Timing Konstanten
E_PULSE = 0.00005
E_DELAY = 0.00005
# Kanalvariablen-Initialisierung
Sensornummer_typ = ['ACURITE','ACURITE','ACURITE','ACURITE','ACURITE','ACURITE','ACURITE','ACURITE']
Logkanalnummer = [True,True,True,True,True,True,True,True]


# Konfigurationsdatei einlesen

Config = ConfigParser.ConfigParser()

Config.read('/var/www/conf/WLANThermo.conf')

#Sensortypen einlesen pro Kanal
Sensornummer_typ[0] =  Config.get('Sensoren','CH0')
Sensornummer_typ[1] =  Config.get('Sensoren','CH1')
Sensornummer_typ[2] =  Config.get('Sensoren','CH2')
Sensornummer_typ[3] =  Config.get('Sensoren','CH3')
Sensornummer_typ[4] =  Config.get('Sensoren','CH4')
Sensornummer_typ[5] =  Config.get('Sensoren','CH5')
Sensornummer_typ[6] =  Config.get('Sensoren','CH6')
Sensornummer_typ[7] =  Config.get('Sensoren','CH7')

#Loggingoptionen einlesen
Logkanalnummer[0] =  Config.getboolean('Logging','CH0')
Logkanalnummer[1] =  Config.getboolean('Logging','CH1')
Logkanalnummer[2] =  Config.getboolean('Logging','CH2')
Logkanalnummer[3] =  Config.getboolean('Logging','CH3')
Logkanalnummer[4] =  Config.getboolean('Logging','CH4')
Logkanalnummer[5] =  Config.getboolean('Logging','CH5')
Logkanalnummer[6] =  Config.getboolean('Logging','CH6')
Logkanalnummer[7] =  Config.getboolean('Logging','CH7')


separator = Config.get('Logging','Separator')


#Soundoption einlesen
sound_on = Config.getboolean('Sound','Beeper_enabled')
websound_on = Config.getboolean('Sound','websound_enabled')

#Einlesen, ueber wieviele Messungen integriert wird 
iterations = Config.getint('Messen','Iterations')

#delay zwischen jeweils 8 Messungen einlesen 
delay = Config.getfloat('Messen','Delay')

#Einlesen des Reihenwiderstandes zum Fuehler (Hardwareabhaengig!!) 
messwiderstand = Config.getint('Messen','Messwiderstand')

#Einlesen Email-Parameter fuer Alarmmeldung
Email_alert = Config.getboolean('Email','email_alert')
Email_server  = Config.get('Email','server')
Email_auth = Config.getboolean('Email','auth')
Email_user = Config.get('Email','username')
Email_password = Config.get('Email','password')
Email_from = Config.get('Email','email_from')
Email_to = Config.get('Email','email_to')
Email_subject = Config.get('Email','email_subject')

#Einlesen Displayeinstellungen
LCD = Config.getboolean('Display','lcd_present')

#Einlesen der Software-Version
build = Config.get('Version','build')

#Einlesen der Logging-Option
newfile = Config.getboolean('Logging','write_new_log_on_restart')


# Pin-Programmierung
GPIO.setup(SCLK, GPIO.OUT)
GPIO.setup(MOSI, GPIO.OUT)
GPIO.setup(MISO, GPIO.IN)
GPIO.setup(CS,   GPIO.OUT)
GPIO.setup(LED_ROT, GPIO.OUT)
GPIO.setup(LED_GELB, GPIO.OUT)
GPIO.setup(LED_GRUEN, GPIO.OUT)
GPIO.setup(BEEPER,  GPIO.OUT)
if LCD:
   GPIO.setup(LCD_E, GPIO.OUT)  # E
   GPIO.setup(LCD_RS, GPIO.OUT) # RS
   GPIO.setup(LCD_D4, GPIO.OUT) # DB4
   GPIO.setup(LCD_D5, GPIO.OUT) # DB5
   GPIO.setup(LCD_D6, GPIO.OUT) # DB6
   GPIO.setup(LCD_D7, GPIO.OUT) # DB7

   #Display initialisieren und Begruessungstext ausgeben
   lcd_init()
   lcd_byte(LCD_LINE_1, LCD_CMD)
   lcd_string("------8-Kanal-------",2) 
   lcd_byte(LCD_LINE_2, LCD_CMD)
   lcd_string("WLAN-Thermometer",2)
   lcd_byte(LCD_LINE_3, LCD_CMD)
   lcd_string("Armin Thinnes",2)
   lcd_byte(LCD_LINE_4, LCD_CMD)
   lcd_string(build,2)    

   time.sleep(3) # 3 second delay 

   lcd_byte(LCD_LINE_1, LCD_CMD)
   lcd_string("Grillsportverein",2)
   lcd_byte(LCD_LINE_2, LCD_CMD)
   lcd_string("",2)  
   lcd_byte(LCD_LINE_3, LCD_CMD)
   lcd_string("Die Referenz zum",1) 
   lcd_byte(LCD_LINE_4, LCD_CMD)
   lcd_string("Grillen und Messen!",1)   

   time.sleep(3) # 3 second delay

   # Blank display
   #lcd_byte(LCD_LINE_1, LCD_CMD)
   #lcd_string("",3)
   #lcd_byte(LCD_LINE_2, LCD_CMD)
   #lcd_string("",3)  
   #lcd_byte(LCD_LINE_3, LCD_CMD)
   #lcd_string("",2) 
   #lcd_byte(LCD_LINE_4, LCD_CMD)
   #lcd_string("",2)

#Thermometer gestartet, einmal 3 LED an und Beep dann alles aus
GPIO.output(LED_ROT, HIGH)
GPIO.output(LED_GELB, HIGH)
GPIO.output(LED_GRUEN, HIGH)
GPIO.output(BEEPER, sound_on)

time.sleep(1)

GPIO.output(LED_ROT, LOW)
GPIO.output(LED_GELB, LOW)
GPIO.output(LED_GRUEN, LOW)
GPIO.output(BEEPER, LOW)

#Temperatur-LOG-Verzeichnis anlegen, wenn noch nicht vorhanden und aktuelle Log-Datei generieren
try:
 os.mkdir('/var/log/WLAN_Thermo')
except: 
 nix=0

name = "/var/log/WLAN_Thermo/TEMPLOG"  + dateiname() + '.csv' #eindeutigen Namen generieren 
if (newfile):# neues File beim Start anlegen
    fw = open(name,'w') #Datei anlegen

    # Falls der Symlink noch da ist, loeschen
    try:
	os.remove('/var/log/WLAN_Thermo/TEMPLOG.csv')
    except:
     nix=0

    os.symlink(name, '/var/log/WLAN_Thermo/TEMPLOG.csv') #Symlink TEMPLOG.csv auf die gerade zu benutzte eindeutige Log-Datei legen.
    kopfzeile='Datum_Uhrzeit' 
    for kanal in range(8):
       if (Logkanalnummer[kanal]):
          kopfzeile = kopfzeile + separator +  'Kanal ' + str(kanal)
    kopfzeile = kopfzeile +'\n'
     

    fw.write(kopfzeile) # Kopfzeile der CSV-Datei schreiben
    fw.close()

else:
    #Kein neues File anlegen
    if os.path.exists('/var/log/WLAN_Thermo/TEMPLOG.csv'): # pruefen, ob die Datei schon da ist zum anhaengen
         name = '/var/log/WLAN_Thermo/TEMPLOG.csv'
        
         
    else:
        # Datei noch nicht vorhanden, doch neu anlegen!
        fw = open(name,'w')
        os.symlink(name, '/var/log/WLAN_Thermo/TEMPLOG.csv')
        kopfzeile='Datum_Uhrzeit' 
        for kanal in range(8):
           if (Logkanalnummer[kanal]):
              kopfzeile = kopfzeile + separator +  'Kanal ' + str(kanal)
        kopfzeile = kopfzeile +'\n'
        fw.write(kopfzeile) # Kopfzeile der CSV-Datei schreiben
        fw.close()



#Alarmstatusspeicher loeschen
Alarm_state_high_previous = 0
Alarm_state_low_previous = 0

while True: #Messchleife
    Alarm_irgendwo = False
    Alarm_message = 'Achtung!\n'
    Alarm_state_high_bin = 0
    Alarm_state_low_bin = 0
    Alarm_high = [999,999,999,999,999,999,999,999]
    Alarm_low = [0,0,0,0,0,0,0,0]
    Temperatur = [0.10,0.10,0.10,0.10,0.10,0.10,0.10,0.10]
    Temperatur_string = ['999.9','999.9','999.9','999.9','999.9','999.9','999.9','999.9']
    Displaytemp = ['999.9','999.9','999.9','999.9','999.9','999.9','999.9','999.9']

    af = open("/var/www/temperaturen.csv") #Datei mit den Alarmwerten einlesen
    for i in range (8):
      Alarm_high[i] = int(af.readline())
    for i in range (8):
      Alarm_low[i] = int(af.readline())
    af.close() 

 
    for kanal in range (8): #Maximal 8 Kanaele abfragen, Kanal binaer mit den LED anzeigen gruen=1 gelb=2 rot=4. 
        sensortyp = Sensornummer_typ[kanal] 
        
        if kanal == 0:
               GPIO.output(LED_GRUEN, LOW)
	       GPIO.output(LED_GELB, LOW)
	       GPIO.output(LED_ROT, LOW)
	elif kanal == 1:
	       GPIO.output(LED_GRUEN, HIGH)
	       GPIO.output(LED_GELB, LOW)
	       GPIO.output(LED_ROT, LOW)
	elif kanal == 2:
	       GPIO.output(LED_GRUEN, LOW)
	       GPIO.output(LED_GELB, HIGH)
	       GPIO.output(LED_ROT, LOW)
	elif kanal == 3:
	       GPIO.output(LED_GRUEN, HIGH)
	       GPIO.output(LED_GELB, HIGH)
	       GPIO.output(LED_ROT, LOW)
	elif kanal == 4:
	       GPIO.output(LED_GRUEN, LOW)
	       GPIO.output(LED_GELB, LOW)
	       GPIO.output(LED_ROT, HIGH)
	elif kanal == 5:
	       GPIO.output(LED_GRUEN, HIGH)
	       GPIO.output(LED_GELB, LOW)
	       GPIO.output(LED_ROT, HIGH)
	elif kanal == 6:
	       GPIO.output(LED_GRUEN, LOW)
	       GPIO.output(LED_GELB, HIGH)
	       GPIO.output(LED_ROT, HIGH)
	elif kanal == 7:
	       GPIO.output(LED_GRUEN, HIGH)
	       GPIO.output(LED_GELB, HIGH)
	       GPIO.output(LED_ROT, HIGH)
	time.sleep(0.5)

	Temp = 0
	for i in range (iterations): #Anzahl iterations Werte messen und Durchschnitt bilden
  	    ADC_Channel = kanal
            Wert =  readAnalogData(ADC_Channel, SCLK, MOSI, MISO, CS)
	    
	    if (Wert > 50) and (Sensornummer_typ[kanal]!='KTYPE'): #sinvoller Wertebereich
	       Rtheta = messwiderstand*((4096.0/Wert) - 1)
	       Tempvar = temperatur_sensor(Rtheta,sensortyp)
	       if Tempvar <> 999.9: #normale Messung, keine Sensorprobleme
	           Temp = Temp + Tempvar    
                   Temperatur[kanal] = round(Temp/iterations,2)
	           
	       else:
		    Temperatur[kanal]  = 999.9 # Problem waehrend des Messzyklus aufgetreten, Errorwert setzen
	    else:
	      if Sensornummer_typ[kanal]=='KTYPE':
		Temperatur[kanal] = Wert*330/4096
	      else:
                   Temperatur[kanal] = 999.9 # kein sinnvoller Messwert, Errorwert setzen
    
        if Temperatur[kanal] <> 999.9:    
	   Temperatur_string[kanal] = ':' + "%.2f" % Temperatur[kanal]
	   if Temperatur[kanal] >= Alarm_high[kanal]:
	      #Alarmstatus high aufdatieren
	      Alarm_irgendwo = True
              Alarm_state_high_bin = Alarm_state_high_bin + pow(2, kanal)
	      Alarm_message = Alarm_message + 'Kanal ' + str(kanal) + ' hat Uebertemperatur!\n'
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      time.sleep(0.2)
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      time.sleep(0.2)
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      Temperatur_string[kanal] = chr(1) + "%.2f" % Temperatur[kanal]
	   if Temperatur[kanal] <= Alarm_low[kanal]:
	      #Alarmstatus low aufdatieren
	      Alarm_irgendwo = True
	      Alarm_state_low_bin = Alarm_state_low_bin + pow(2, kanal) 
	      Alarm_message = Alarm_message + 'Kanal ' + str(kanal) + ' hat Untertemperatur!\n'
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      time.sleep(0.2)
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      time.sleep(0.2)
	      GPIO.output (BEEPER,sound_on)
	      time.sleep(0.2)
	      GPIO.output (BEEPER, LOW)
	      Temperatur_string[kanal] = chr(0) + "%.2f" % Temperatur[kanal]

#   Pruefen, ob mehr Alarmzustaende gegenueber dem letzten Lauf vorliegen. Wenn ja, email schicken, wenn gewuenscht.
    
    if ((Alarm_state_high_bin > Alarm_state_high_previous) or (Alarm_state_low_bin > Alarm_state_low_previous)):
       
       if Email_alert: #wenn konfiguriert, email schicken
          alarm_email(Email_server,Email_user,Email_password, Email_from, Email_to, Email_subject, Alarm_message)
          print 'Alarmmail gesendet!'
    
    Alarm_state_high_previous = Alarm_state_high_bin #aktuellen Alarm-Status sichern
    Alarm_state_low_previous = Alarm_state_low_bin   
   
   #Temperaturen auf Display anzeigen
    if LCD:
       for kanal in range(8):
        if Temperatur[kanal] <> 999.9:
         Displaytemp[kanal] = Temperatur_string[kanal]
        else:
         Displaytemp[kanal] = ': ERR '

       lcd_byte(LCD_LINE_1, LCD_CMD)
       Meldung = 'C0' + Displaytemp[0] + chr(0xdf)+'C1' + Displaytemp[1] + chr(0xdf)
       lcd_string(Meldung,2)
       lcd_byte(LCD_LINE_2, LCD_CMD)
       Meldung = 'C2' + Displaytemp[2] + chr(0xdf) + 'C3' + Displaytemp[3] + chr(0xdf)
       lcd_string(Meldung,2)
       lcd_byte(LCD_LINE_3, LCD_CMD)
       Meldung = 'C4' + Displaytemp[4] + chr(0xdf) + 'C5' + Displaytemp[5] + chr(0xdf)
       lcd_string(Meldung,2)
       lcd_byte(LCD_LINE_4, LCD_CMD)
       Meldung = 'C6' + Displaytemp[6] + chr(0xdf) + 'C7' + Displaytemp[7] + chr(0xdf)
       lcd_string(Meldung,2)


 # PHP-Includedatei erzeugen
    lt = time.localtime()#  Uhrzeit des Messzyklus
    jahr, monat, tag, stunde, minute, sekunde = lt[0:6]
    Uhrzeit = string.zfill(stunde,2) + ':' + string.zfill(minute,2)+ ':' + string.zfill(sekunde,2)
    Uhrzeit_lang = string.zfill(tag,2) + '.' + string.zfill(monat,2) + '.' + string.zfill((jahr-2000),2) + ' ' + Uhrzeit
    fw = open('/var/www/temp.inc.php','w')
    fw.write('<?php\n\n')


    for kanal in range(8):# Jeweils eine Zeile mit Temperatur
       if Temperatur[kanal] <> 999.9:
          phpline = '$temp_' + str(kanal) + ' = "' + str(Temperatur[kanal]) + '";\n'

       else:
          phpline = '$temp_' + str(kanal) + ' = "ERROR";\n'  # Hier "Error" in "0" aendern, wenn da 0 erscheinen soll
       fw.write(phpline)
    fw.write('\n$time_stamp = "')
    fw.write(Uhrzeit_lang)
    fw.write('";\n$pyversion = "')
    fw.write(build)
    fw.write('"\n?>\n') 
    fw.close()


   
# Generierung des Logfiles
    
    
    logfile = open(name,'a')#logfile oeffnen
 
    
    #Messzyklus protokollieren und nur die Kanaele loggen, die in der Konfigurationsdatei angegeben sind
    schreiben = Uhrzeit_lang
    for i in range(8):
       if (Logkanalnummer[i]):
          schreiben=schreiben + separator + str(Temperatur[i])
    schreiben = schreiben +'\n'
    logfile.write(schreiben)
    logfile.close()
    print schreiben # nur relevant wenn nicht als Dienst gestartet. Man sieht die aktuelle Logzeile

    
    time.sleep(delay) 
